//********************************************************************************
//
//                       C O P Y R I G H T  (c) 2011
//                  S O F T W A R E   T O O L B O X   I N C.
//                           All Rights Reserved.
//   ........................................................................
//   This sample code is provided by Software Toolbox solely to sist in
//   understanding the use of the SLIK OPC Data Access ActiveX Control. This
//   code is provided -is and without warranty or support of any sort.
//
//********************************************************************************
//
//   Project:		SLIK-DA Interop Assembly
//
//   Description:   This sample server application is based on Software Toolbox's
//                  Advanced Language Independent Toolkit for creating OPC Data
//                  Access servers (SLIK-DA).  It leverages the SLIK-DA Interop
//					Assembly that allows for the easy integration of this
//					ActiveX control into .NET applications.
//
//					This implementation replicates the VB Advanced Server originally
//					created to demonstrate various features of the SLIK-DA ActiveX 
//					Control in the VB6 environment.
//
//********************************************************************************

using System.Windows.Forms;
using NDI.SLIKDA.Interop;
using CSAdvancedServer;

namespace CSAdvancedServer
{
	//
	//	The CSlikUtil class provides services that were originally provided
	//	in the "mdlSLIK" Module in the VB Advanced Server sample.
	//
	public class CSlikUtil
	{	
		// Range of valid values for server statistics sample periods (in milliseconds)
		public const int c_nMinStatSamplePeriod = 100;
		public const int c_nMaxStatSamplePeriod = 60000;
		
		// Range of valid values for minimum group update period (in milliseconds)
		public const int c_nMinGroupMinUpdatePeriod   = 10;
		public const int c_nMaxGroupMinUpdatePeriod   = 60000;
		
		// SLIK Server Statistics
		public const short c_nStatSamplePeriod	= 0;
		public const short c_nStatClients		= 1;
		public const short c_nStatGroups		= 2;
		public const short c_nStatItems			= 3;
		public const short c_nStatReads			= 4;
		public const short c_nStatWrites		= 5;
		public const short c_nStatChanges		= 6;
		
		public const string c_sStatSamplePeriod	= "SAMPLE_PERIOD";
		public const string c_sStatClients		= "NUM_CLIENTS";
		public const string c_sStatGroups		= "NUM_GROUPS";
		public const string c_sStatItems		= "NUM_ITEMS";
		public const string c_sStatReads		= "NUM_READS_PER_PD";
		public const string c_sStatWrites		= "NUM_WRITES_PER_PD";
		public const string c_sStatChanges		= "NUM_CHG_PER_PD";


		//********************************************************************************
		// Description:      Create the item namespace for this server. The items will be
		//                   organized by access rights and data type. The item tags will
		//                   make use of the SLIK server Namespace Delimiter property to
		//                   create a hierarchial namespace.
		//
		// Parameters:
		//   In:             SLIKServer - the instance of the SLIK server
		//					 f - a reference to the main form object.	
		//
		//   Out:            None
		//
		// Return Value:     True - namespace created successfully
		//                   False - error occurred
		//********************************************************************************
		public static bool InitNamespace(
			ref SLIKServer slikSvr, 
			frmMain f 
			)
		{
			const short nTagsPerLeafFolder  = 10;
			int nAccess;
			short nIndex;
		
			try
			{
				ISLIKTags Tags = slikSvr.SLIKTags;
			
				//
				// Create a set of tags that will change in value over time.
				//
				nAccess = (int ) AccessPermissionsEnum.sdaReadAccess;

				for( nIndex = 1; nIndex <= nTagsPerLeafFolder; nIndex++ )
				{
					Tags.Add( 
						"src.BOOL.tag" + nIndex.ToString("00"), 
						nAccess, 
						true, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);
				
					Tags.Add(
						"src.UI1.tag" + nIndex.ToString("00"), 
						nAccess, 
						(byte) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);
				
					Tags.Add(
						"src.I2.tag" + nIndex.ToString("00"), 
						nAccess, 
						(short) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.I4.tag" + nIndex.ToString("00"), 
						nAccess,
						(int) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.R4.tag" + nIndex.ToString("00"), 
						nAccess, 
						(float) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.R8.tag" + nIndex.ToString("00"), 
						nAccess, 
						(double) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.BSTR.tag" + nIndex.ToString("00"), 
						nAccess, 
						"" + nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.DATE.tag" + nIndex.ToString("00"), 
						nAccess, 
						System.DateTime.FromOADate(nIndex), 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"src.CY.tag" + nIndex.ToString("00"), 
						nAccess, 
						new System.Runtime.InteropServices.CurrencyWrapper(nIndex), 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);
				}

				//
				// Create a set of tags that any OPC client may change.
				//
				nAccess = (int)( AccessPermissionsEnum.sdaReadAccess | AccessPermissionsEnum.sdaWriteAccess );

				for( nIndex = 1; nIndex <= nTagsPerLeafFolder; nIndex++ )
				{
					Tags.Add(
						"trg.BOOL.tag" + nIndex.ToString("00"), 
						nAccess, 
						true, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.UI1.tag" + nIndex.ToString("00"), 
						nAccess, 
						(byte) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.I2.tag" + nIndex.ToString("00"), 
						nAccess, 
						(short) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.I4.tag" + nIndex.ToString("00"), 
						nAccess, 
						(int) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.R4.tag" + nIndex.ToString("00"), 
						nAccess, 
						(float) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.R8.tag" + nIndex.ToString("00"), 
						nAccess, 
						(double) nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);
				
					Tags.Add(
						"trg.BSTR.tag" + nIndex.ToString("00"), 
						nAccess, 
						"" + nIndex, 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.DATE.tag" + nIndex.ToString("00"), 
						nAccess, 
						System.DateTime.FromOADate(nIndex),
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);

					Tags.Add(
						"trg.CY.tag" + nIndex.ToString("00"), 
						nAccess, 
						new System.Runtime.InteropServices.CurrencyWrapper(nIndex), 
						(short) QualityStatusEnum.sdaGood, 
						DefaultValues.Add_InitialTimestamp, 
						DefaultValues.Add_AccessPaths
						);
				}
				return true;
			}
			catch( System.Exception e )
			{
				f.ReportEvent(e.Message, "Namespace initialization error");
				return false;
			}
		}

		//********************************************************************************
		// Description:      Convert the server status value to a string.
		//
		// Parameters:
		//   In:             nStatus - Server status
		//   Out:            None
		//
		// Return Value:     Text equivalent (or empty string if no match found)
		//********************************************************************************
		public static string ServerStatusToStr(NDI.SLIKDA.Interop.ServerStatusEnum nStatus )
		{
			string ServerStatusToStr;
			switch(nStatus)
			{
				case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusFailed:
					ServerStatusToStr = "Failed";
					break;
				case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusNoConfig:
					ServerStatusToStr = "No Configuration";
					break;
				case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusRunning:
					ServerStatusToStr = "Running";
					break;
				case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusSuspended:
					ServerStatusToStr = "Suspended";
					break;
				case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusTest:
					ServerStatusToStr = "Test";
					break;
				default:
					ServerStatusToStr = "UNKNOWN!";
					break;
			}
			return ServerStatusToStr;
		}
	}
}